*                                                                                  ;
 *    Reading in the 1974 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam74.raw' ;
 
 data one;
 
   infile 'F:\PSID\74FAM.DAT'  lrecl=608 missover;
   INPUT
   V3401 1-3              V3402 4-7              V3403 8-9
   V3404 10-12            V3405 13-17            V3406 18
   V3407 19               V3408 20               V3409 21
   V3410 22               V3411 23               V3412 24
   V3413 25               V3414 26               V3415 27
   V3416 28               V3417 29-33            V3418 34
   V3419 35-38            V3420 39               V3421 40-43
   V3422 44               V3423 45-48            V3424 49
   V3425 50-53            V3426 54               V3427 55-58
   V3428 59               V3429 60-62            V3430 63
   V3431 64-67            V3432 68               V3433 69-70 .2
   V3434 71               V3435 72-73 .2         V3436 74
   V3437 75-76            V3438 77               V3439 78-82 .2
   V3440 83-87            V3441 88-91            V3442 92
   V3443 93-96            V3444 97               V3445 98-101
   V3446 102              V3447 103              V3448 104
   V3449 105-108          V3450 109              V3451 110-113
   V3452 114              V3453 115-118          V3454 119
   V3455 120              V3456 121              V3457 122
   V3458 123-127          V3459 128              V3460 129
   V3461 130              V3462 131              V3463 132-136
   V3464 137              V3465 138-142          V3466 143
   V3467 144              V3468 145              V3469 146
   V3470 147              V3471 148              V3472 149-153
   V3473 154              V3474 155-159          V3475 160
   V3476 161-165          V3477 166-170          V3478 171
   V3479 172-176          V3480 177-181          V3481 182-186
   V3482 187-191          V3483 192-196          V3484 197
   V3485 198              V3486 199              V3487 200
   V3488 201-205          V3489 206-209          V3490 210-214
   V3491 215              V3492 216-220          V3493 221-225
   V3494 226              V3495 227              V3496 228
   V3497 229-232          V3498 233-236          V3499 237-240
   V3500 241-244          V3501 245-248          V3502 249-252
   V3503 253-261          V3504 262-263          V3505 264
   V3506 265-267          V3507 268-269          V3508 270-271
   V3509 272              V3510 273-274          V3511 275-276
   V3512 277-278          V3513 279              V3514 280
   V3515 281              V3516 282              V3517 283
   V3518 284              V3519 285              V3520 286-290
   V3521 291              V3522 292              V3523 293
   V3524 294              V3525 295              V3526 296
   V3527 297              V3528 298              V3529 299-301
   V3530 302              V3531 303-304          V3532 305
   V3533 306              V3534 307              V3535 308
   V3536 309              V3537 310              V3538 311
   V3539 312-313          V3540 314              V3541 315-316
   V3542 317              V3543 318-319          V3544 320-321
   V3545 322-323          V3546 324              V3547 325-327
   V3548 328              V3549 329-331          V3550 332
   V3551 333              V3552 334              V3553 335-337
   V3554 338-339          V3555 340-341          V3556 342
   V3557 343              V3558 344              V3559 345
   V3560 346-347          V3561 348              V3562 349
   V3563 350              V3564 351-353          V3565 354
   V3566 355              V3567 356              V3568 357-359
   V3569 360              V3570 361-362          V3571 363
   V3572 364-365          V3573 366-367          V3574 368-369
   V3575 370-371          V3576 372-373          V3577 374
   V3578 375              V3579 376-378          V3580 379
   V3581 380-382          V3582 383              V3583 384
   V3584 385              V3585 386-388          V3586 389
   V3587 390-391          V3588 392-393          V3589 394-395
   V3590 396              V3591 397              V3592 398-400
   V3593 401              V3594 402              V3595 403
   V3596 404              V3597 405-407          V3598 408
   V3599 409              V3600 410-412          V3601 413
   V3602 414-415          V3603 416-417          V3604 418-419
   V3605 420              V3606 421              V3607 422
   V3608 423              V3609 424              V3610 425-426
   V3611 427-428          V3612 429              V3613 430
   V3614 431              V3615 432              V3616_1 433
   V3616_2 434            V3617 435-436          V3618 437-439
   V3619 440              V3620 441-442          V3621 443-444
   V3622 445              V3623 446-447          V3624 448
   V3625 449              V3626 450              V3627 451
   V3628 452              V3629 453              V3630 454
   V3631 455              V3632 456              V3633 457
   V3634 458              V3635 459              V3636 460
   V3637 461              V3638 462              V3639 463
   V3640 464-465          V3641 466-468          V3642 469-470
   V3643 471-473          V3644 474              V3645 475
   V3646 476              V3647 477-478          V3648 479-480
   V3649 481-482          V3650 483-484          V3651 485
   V3652 486              V3653 487              V3654 488
   V3655 489-490          V3656 491-493          V3657 494
   V3658 495              V3659 496              V3660 497
   V3661 498              V3662 499              V3663 500
   V3664 501              V3665 502              V3666 503
   V3667 504              V3668 505              V3669 506
   V3670 507              V3671 508              V3672 509-511
   V3673 512              V3674 513-516          V3675 517
   V3676 518-522          V3677 523              V3678 524
   V3679 525              V3680 526              V3681 527
   V3682 528              V3683 529              V3684 530
   V3685 531              V3686 532              V3687 533
   V3688 534              V3689 535-539          V3690 540
   V3691 541              V3692 542-545 .2       V3693 546
   V3694 547-550          V3695 551-554 .2       V3696 555
   V3697 556-559 .2       V3698 560              V3699 561
   V3700 562              V3701 563              V3702 564
   V3703 565              V3704 566              V3705 567-568
   V3706 569-570          V3707 571-575          V3708 576
   V3709 577              V3710 578              V3711 579
   V3712 580              V3713 581-582 .1       V3714 583
   V3715 584-585          V3716 586-589          V3717 590
   V3718 591              V3719 592              V3720 593
   V3721 594-595          V3722 596              V3723 597
   V3724 598              V3725 599              V3726 600
   V3727 601              V3728 602              V3729 603
   V3730 604-607          V3731 608;

* SAS LABEL STATEMENT;

LABEL
   V3401 = "STUDY NUMBER"
   V3402 = "1974 ID NUMBER"
   V3403 = "CURRENT STATE   69:10-11"
   V3404 = "CURRENT COUNTY  69:12-14"
   V3405 = "CURRENT ST &  CO 69:10-14"
   V3406 = "SIZE OF LGST SMSA  69:16"
   V3407 = "COLOR COVERSHEET   69:18"
   V3408 = "WTR ORIG REFUSED   69:20"
   V3409 = "WTR TELE INT       69:22"
   V3410 = "FAM COMP CHG       69:24"
   V3411 = "# MOVED IN         69:15"
   V3412 = "WHO MOVED IN       69:17"
   V3413 = "# MOVED OUT        69:19"
   V3414 = "WHO MOVED OUT      69:21"
   V3415 = "CURRENT FAM COMP   69:23"
   V3416 = "QUALITY OF MATCH   69:25"
   V3417 = "HOUSE VALUE     69:26-30"
   V3418 = "ACC HOUSE VALUE    69:31"
   V3419 = "ANNUAL RENT     69:32-35"
   V3420 = "ACC ANN RENT       69:36"
   V3421 = "ANN VAL IF RNTD 69:37-40"
   V3422 = "ACC ANN VAL IFRNTD 69:41"
   V3423 = "ANN WRK HRS-HD  69:42-45"
   V3424 = "ACC ANN WK HRS     69:46"
   V3425 = "ANN ILLNESS HRS 69:47-50"
   V3426 = "ACC ANN ILL HRS    69:51"
   V3427 = "ANN UNEMPL HRS  69:52-55"
   V3428 = "ACC ANN UNEMP HRS  69:56"
   V3429 = "ANN HRS TRAV-WK 69:57-59"
   V3430 = "ACC HRS TRAV TO WK 69:60"
   V3431 = "ANN WRK HRS-WIFE69:61-64"
   V3432 = "ACC ANN WF WK HRS  69:65"
   V3433 = "PRT-TIME FRAC-WF70:10-11"
   V3434 = "ACC PTTIME FRAC-WF 70:12"
   V3435 = "PRT-TIME FRAC-HD70:13-14"
   V3436 = "ACC PTTIME FRAC-HD 70:15"
   V3437 = "FAMILY SIZE     70:16-17"
   V3438 = "# REQ ROOMS        70:18"
   V3439 = "WEEKLY FD NEED  70:19-23"
   V3440 = "ANN NEED STND   70:24-28"
   V3441 = "ANN FOOD AT HOME70:29-32"
   V3442 = "ACC FOOD AT HOME   70:33"
   V3443 = "AMT SAVD FD STMP70:34-37"
   V3444 = "ACC AMT SVD FD STMP70:38"
   V3445 = "ANN $  EATNG OUT 70:39-42"
   V3446 = "ACC $  EATING OUT   70:43"
   V3447 = "WTR INCL VAL STAMPS70:44"
   V3448 = "FREQ USE FD STAMPS 70:45"
   V3449 = "ANN HSWK HRS 1ST70:46-49"
   V3450 = "ACC HSWK HRS 1ST   70:50"
   V3451 = "ANN HSWK HR-HUSB70:51-54"
   V3452 = "ACC HSWK HRS-HUSB  70:55"
   V3453 = "ANN HSWK HR-OTHR70:56-59"
   V3454 = "ACC HSWK HRS-OTHRS 70:60"
   V3455 = "# MAJOR ADULTS     70:61"
   V3456 = "BKT LBR INC-FARM   71:10"
   V3457 = "BKT LABOR INC-BUS  71:11"
   V3458 = "ANN WAGE-HEAD   71:12-16"
   V3459 = "ACC ANN WAGE-HD    71:17"
   V3460 = "BKT BONUS,OT,COMM  71:18"
   V3461 = "BKT LABR PROF PRAC 71:19"
   V3462 = "BKT LBR ROOMERS    71:20"
   V3463 = "TOT LABOR INC-HD71:21-25"
   V3464 = "ACC LABOR INC-HD   71:26"
   V3465 = "TOT LABOR INC-WF71:27-31"
   V3466 = "ACC LABOR INC-WF   71:32"
   V3467 = "BKT ASSET FARM INC 71:33"
   V3468 = "BKT ASSET BUS INC  71:34"
   V3469 = "BKT ASSET ROOMERS  71:35"
   V3470 = "BKT RENT,DIV,INT   71:36"
   V3471 = "BKT ASSET INC-WF   71:37"
   V3472 = "TXBLE INC-HD& WF 71:38-42"
   V3473 = "ACC ASSET INC      71:43"
   V3474 = "AMT OUTSIDE DEP 71:44-48"
   V3475 = "# DEPENDENTS       71:49"
   V3476 = "TOT TAXES-HD& WF 71:50-54"
   V3477 = "ANN ADC,AFDC Y  72:10-14"
   V3478 = "ACC ADC,AFDC INC   72:15"
   V3479 = "ANN OTR WELFARE 72:16-20"
   V3480 = "ANN SOC SECURTY 72:21-25"
   V3481 = "ANN OTR RETRMNT 72:26-30"
   V3482 = "ANN UNEMP COMP  72:31-35"
   V3483 = "ANN ALIMONY     72:36-40"
   V3484 = "BKT HELP FR RELATS 72:41"
   V3485 = "BKT ANYTHING ELSE  72:42"
   V3486 = "BKT WF TRANSFR Y   72:43"
   V3487 = "ACC TRNSFRS EX ADC 72:44"
   V3488 = "TOT TRANSFER Y  72:45-49"
   V3489 = "ANN WK HRS-OTRS 72:50-53"
   V3490 = "TOT TXBL INC-OTR72:54-58"
   V3491 = "ACC TXBL INC-OTRS  72:59"
   V3492 = "TOT TAXES-OTRS  72:60-64"
   V3493 = "TOT TRNSFR-OTRS 72:65-69"
   V3494 = "ACC TRANSFER 4-OTRS72:70"
   V3495 = "# OTHR INC RECRS   72:71"
   V3496 = "# OTR Y REC W/LABOR72:72"
   V3497 = "1968 ID NUMBER  73:10-13"
   V3498 = "1969 ID NUMBER  73:14-17"
   V3499 = "1970 ID NUMBER  73:18-21"
   V3500 = "1971 ID NUMBER  73:22-25"
   V3501 = "1972 ID NUMBER  73:26-29"
   V3502 = "1973 ID NUMBER  73:30-33"
   V3503 = "IWR SOC SEC #   73:34-42"
   V3504 = "IWRS INT #      73:43-44"
   V3505 = "DATE OF INTERVIEW  73:45"
   V3506 = "LENGTH OF INT   73:46-48"
   V3507 = "# IN FU         73:49-50"
   V3508 = "AGE OF HEAD     73:51-52"
   V3509 = "SEX OF HEAD        73:53"
   V3510 = "AGE OF WIFE     73:54-55"
   V3511 = "# KIDS IN FU    73:56-57"
   V3512 = "AGE YNGST KID   73:58-59"
   V3513 = "KIDS <25 IN FU?    73:60"
   V3514 = "KIDS STOP SCHOOL?  73:61"
   V3515 = "PUB TRANSPORT NEAR?73:62"
   V3516 = "PUB TRANS GOOD?    73:63"
   V3517 = "OWN CAR/TRUCK?     73:64"
   V3518 = "PROBS W/NO CAR?    73:65"
   V3519 = "WHAT PROBS NO CAR  73:66"
   V3520 = "ANN # MI DRIVEN 73:67-71"
   V3521 = "ACTUAL # ROOMS     73:72"
   V3522 = "HOUSING STATUS     73:73"
   V3523 = "HOW NOT OWN/RENT   73:74"
   V3524 = "MOVED SINCE SPRING?73:75"
   V3525 = "WHY MOVED?         73:76"
   V3526 = "WTR MIGHT MOVE     73:77"
   V3527 = "WHY MIGHT MOVE     73:78"
   V3528 = "EMPLOYMENT STATUS  74:10"
   V3529 = "3-DIGIT OCC (E) 74:11-13"
   V3530 = "1-DIGIT OCC (E)    74:14"
   V3531 = "INDUSTRY (E)    74:15-16"
   V3532 = "WTR SELF-EMPLD (E) 74:17"
   V3533 = "LNGTH PRSNT JOB (E)74:18"
   V3534 = "WHY LEFT JOB (E)   74:19"
   V3535 = "PRES JOB PAY >? (E)74:20"
   V3536 = "PRES JOB BETTER?(E)74:21"
   V3537 = "WHY JOB BETTER (E) 74:22"
   V3538 = "WTR VACATION (E)   74:23"
   V3539 = "WKS VACATION(E) 74:24-25"
   V3540 = "WTR ILL (E)        74:26"
   V3541 = "# WKS ILL (E)   74:27-28"
   V3542 = "WTR UNEMPLYD (E)   74:29"
   V3543 = "WKS UNEMPLYD (E)74:30-31"
   V3544 = "WKS WRKD-MAIN(E)74:32-33"
   V3545 = "HR/WK WKD MAIN-E74:34-35"
   V3546 = "PAID OVERTIME? (E) 74:36"
   V3547 = "PAY/HR FOR OT(E)74:37-39"
   V3548 = "WTR HRLY WAGE (E)  74:40"
   V3549 = "HRLY WAGE MAIN-E74:41-43"
   V3550 = "WTR XTRA JOB (E)   74:44"
   V3551 = "OCC-XTRA JOB (E)   74:45"
   V3552 = "# EXTRA JOBS (E)   74:46"
   V3553 = "HRLY WAGE XTRA-E74:47-49"
   V3554 = "WKS WKD-XTRA(E) 74:50-51"
   V3555 = "HR/WK WKD XTRA-E74:52-53"
   V3556 = "COULD WRK MORE?(E) 74:54"
   V3557 = "WANT MORE WK? (E)  74:55"
   V3558 = "COULD WRK LESS?(E) 74:56"
   V3559 = "WANT LESS WRK? (E) 74:57"
   V3560 = "# MI TO WRK (E) 74:58-59"
   V3561 = "MODE TRANS TO WRK-E74:60"
   V3562 = "MGHT GET NEW JOB?-E74:61"
   V3563 = "KIND JOB SOUGHT (U)75:11"
   V3564 = "PAY/HR SOUGHT(U)75:12-14"
   V3565 = "NEED TRAINING?(U)  75:15"
   V3566 = "WHAT DO FIND JOB(U)75:16"
   V3567 = "# PLAC FOR JOB (U) 75:17"
   V3568 = "3-DIGIT OCC-U   75:18-20"
   V3569 = "1-DIGIT OCC (U)    75:21"
   V3570 = "INDUSTRY (U)    75:22-23"
   V3571 = "WHAT HAPND JOB? (U)75:24"
   V3572 = "WKS WRKD (U)    75:25-26"
   V3573 = "HR/WK WRKD (U)  75:27-28"
   V3574 = "WKS ILL (U)     75:29-30"
   V3575 = "WKS UNEMPLD (U) 75:31-32"
   V3576 = "# MI TO WK (U)  75:33-34"
   V3577 = "HOW GOT TO WRK (U) 75:35"
   V3578 = "JOBS NOT WORTH IT-U75:36"
   V3579 = "PAY/HR BAD JOB-U75:37-39"
   V3580 = "MOVE FOR JOB? (U)  75:40"
   V3581 = "PAY/HR TOMOVE-U 75:41-43"
   V3582 = "WHY NOT MOVE JOB-U 75:44"
   V3583 = "WRK FOR $ ? (R)     75:45"
   V3584 = "THINK MIGHT WRK?-R 75:46"
   V3585 = "3-DIGIT OCC (R) 75:47-49"
   V3586 = "1-DIGIT OCC (R)    75:50"
   V3587 = "INDUSTRY (R)    75:51-52"
   V3588 = "WKS WRKD (R)    75:53-54"
   V3589 = "HR/WK WRKD (R)  75:55-56"
   V3590 = "MGHT GET NEW JOB-R 75:57"
   V3591 = "TYPE JOB MIGHT-R   75:58"
   V3592 = "PAY/HR NEW JOB-R75:59-61"
   V3593 = "NEED TRAINING? (R) 75:62"
   V3594 = "WHAT DO FIND JOB-R 75:63"
   V3595 = "# PLAC FOR JOB (R) 75:64"
   V3596 = "UNWORTHY JOBS? (R) 75:65"
   V3597 = "PAY/HR BAD JOBS 75:66-68"
   V3598 = "MARITAL STATUS     76:10"
   V3599 = "DID WIFE WORK?     76:11"
   V3600 = "3-DIGIT OCC-WF  76:12-14"
   V3601 = "1-DIGIT OCC-WIFE   76:15"
   V3602 = "INDUSTRY-WF     76:16-17"
   V3603 = "WKS WRKD-WIFE   76:18-19"
   V3604 = "HR/WK WORKED-WF 76:20-21"
   V3605 = "COULD WRK MORE?-WF 76:22"
   V3606 = "LIKE MOREWWORK?-WF 76:23"
   V3607 = "WIFE WILL/WONT WRK 76:24"
   V3608 = "EDUCATION-WF FA    76:25"
   V3609 = "EDUCATION-WF MOM   76:26"
   V3610 = "# YRS WF WKD    76:27-28"
   V3611 = "YRS WKD FULL-WF 76:29-30"
   V3612 = "KIDS<12 IN FU?     76:31"
   V3613 = "KID-MARITAL STAT   76:32"
   V3614 = "MODE CHILD CARE 1ST76:33"
   V3615 = "MODE CHILD CARE 2ND76:34"
   V3616_1 = "BOTH MODES CH C 76:33-34 RESP 1"
   V3616_2 = "BOTH MODES CH C 76:33-34 RESP 2"
   V3617 = "HR/WK CHILD CARE76:35-36"
   V3618 = "$ /WK FOR CH CARE76:37-39"
   V3619 = "BKDOWN CH CARE ARR 76:40"
   V3620 = "# YRS HD WKD    76:41-42"
   V3621 = "YRS WKD FULL-HD 76:43-44"
   V3622 = "REL TO HD HSWRKR   76:45"
   V3623 = "HR/WK 1ST HSWRKR76:46-47"
   V3624 = "OTRS HELP W/HSWK?  76:48"
   V3625 = "TOT RECTS FARM     76:50"
   V3626 = "WTR OWN BUSINESS   76:51"
   V3627 = "CORPORATION OR?    76:52"
   V3628 = "WTR LUMP SUM PYTS  76:53"
   V3629 = "BKT AMT LUMP SUM   76:54"
   V3630 = "WTR OUTSIDE DEPS   76:55"
   V3631 = "# OUTSIDE DEPS     76:56"
   V3632 = "WTR DEPS>HALF SUPPT76:57"
   V3633 = "# DEP>HALF SUPPORT 76:58"
   V3634 = "EDUCATION-HD MO    76:59"
   V3635 = "BROS/SIS OLDER?    76:60"
   V3636 = "WTR BELONG LABOR UN76:61"
   V3637 = "WTR NEW WIFE IN FU 77:10"
   V3638 = "EDUCATION-WIFE     77:11"
   V3639 = "WTR NEW HEAD IN FU 77:12"
   V3640 = "ST GREW UP-FA   77:13-14"
   V3641 = "CO GREW UP-FA   77:15-17"
   V3642 = "ST GREW UP-MOM  77:18-19"
   V3643 = "CO GREW UP-MOM  77:20-22"
   V3644 = "OCCUPATION-FA      77:23"
   V3645 = "OCC-HD 1ST JOB     77:24"
   V3646 = "DIFFERENT JOBS OR? 77:25"
   V3647 = "AGE HD 1ST KID  77:26-27"
   V3648 = "AGE HD 2ND KID  77:28-29"
   V3649 = "AGE HD 3RD KID  77:30-31"
   V3650 = "TOT # KIDS OF HD77:32-33"
   V3651 = "# KIDS BY AGE 25   77:34"
   V3652 = "# BROS &  SIS-HD    77:35"
   V3653 = "RELIGIOUS PREF     77:36"
   V3654 = "GROW UP FARM?-HD   77:37"
   V3655 = "ST GREW UP-HD   77:38-39"
   V3656 = "CO GREW UP-HD   77:40-42"
   V3657 = "# REGNS HD LVD IN  77:43"
   V3658 = "# STS HD LVD IN    77:44"
   V3659 = "EVER MOVED FR JOB? 77:45"
   V3660 = "NOT MOVED FOR JOB? 77:46"
   V3661 = "PARENTS POOR?      77:47"
   V3662 = "EDUCATION-HD FA    77:48"
   V3663 = "EDUCATION-HEAD     77:49"
   V3664 = "XTRA TRAINING-HD   77:50"
   V3665 = "WTR VETERAN        77:51"
   V3666 = "HLTH LIMIT TYPE WK?77:52"
   V3667 = "HOW MUCH HLTH LIMT?77:53"
   V3668 = "HOW LONG HLTH LIMT?77:54"
   V3669 = "HLTH BETTER OR?    77:55"
   V3670 = "WHO RESPONDENT     77:56"
   V3671 = "# OF CALLS         77:57"
   V3672 = "NEAREST SMSA    77:58-60"
   V3673 = "DIST FR CNTR SMSA  77:61"
   V3674 = "YRLY PROPRTY TAXES 4V274"
   V3675 = "HOUSE VALUE BKT    4V275"
   V3676 = "TOT FU MON INC     4V276"
   V3677 = "TOT FU MON INC BKT 4V277"
   V3678 = "HD TOT LABOR Y BKT 4V278"
   V3679 = "WF TOT LABOR Y BKT 4V279"
   V3680 = "TOT TAX Y H+W BKT 4V280"
   V3681 = "TOT TAX Y-OTHR BKT 4V281"
   V3682 = "H+W ADC-AFDC BKT   4V282"
   V3683 = "H+W OTHER WELF BKT 4V283"
   V3684 = "H+W SOC SECUR BKT  4V284"
   V3685 = "HD OTHER RETIR BKT 4V285"
   V3686 = "HDS UNEMPLOY BKT   4V286"
   V3687 = "HDS ALIMONY BKT    4V287"
   V3688 = "H+W TOT TRNS Y BKT 4V288"
   V3689 = "H+W MISC TRANSFERS 4V289"
   V3690 = "H+W MISC TRANS BKT 4V290"
   V3691 = "TOT TRNS Y-OTR BKT 4V291"
   V3692 = "MONEY Y/NEEDS      4V292"
   V3693 = "MONEY Y/NEEDS BKT  4V293"
   V3694 = "ANNUAL FOOD STD    4V294"
   V3695 = "HDS AVG HRLY EARN  4V295"
   V3696 = "BKT HD AVG HR EARN 4V296"
   V3697 = "WIFE AVG HRLY EARN 4V297"
   V3698 = "BKT WF AVG HR EARN 4V298"
   V3699 = "CURRENT REGION     4V299"
   V3700 = "REGION HD GREW UP  4V300"
   V3701 = "REGION DAD GREW UP 4V301"
   V3702 = "REGION MOM GREW UP 4V302"
   V3703 = "GEOGRAPH MOBILITY  3V303"
   V3704 = "ACCURACY MONEY Y   4V304"
   V3705 = "# MINOR ASSIGNMENT 4V305"
   V3706 = "# MAJOR ASSIGNMENT 4V306"
   V3707 = "VALUE PER ROOM     4V307"
   V3708 = "BKT VALUE PER ROOM 4V308"
   V3709 = "BKT HR WAGE OV-TIM 4V309"
   V3710 = "BKT REG HRLY WAGE  4V310"
   V3711 = "BKT HR WAGE 2ND JB 4V311"
   V3712 = "BKT ACTL-REQD ROOM 4V312"
   V3713 = "PERSONS PER ROOM   4V313"
   V3714 = "BKT PERSONS/ROOM   4V314"
   V3715 = "NUMBER OF ADULTS   4V315"
   V3716 = "HOUSEWORK H+W      4V316"
   V3717 = "ONE DIGIT FAM SIZE 4V317"
   V3718 = "BKT AGE OF HEAD    4V318"
   V3719 = "BKT AGE OF WIFE    4V319"
   V3720 = "RACE 4V320"
   V3721 = "1974 FAMILY WEIGHT"
   V3722 = "DEC-TOT FU $  Y BKT 4V277"
   V3723 = "DEC-MON Y/NEED BKT 4V293"
   V3724 = "UNSKILLED MALE"
   V3725 = "COMP FEMALE/MALE"
   V3726 = "COMP WHITE/NONWHITE"
   V3727 = "UNSKILLED MALE WAGE"
   V3728 = "UNSKILLED FEM WAGE"
   V3729 = "UNEMPLOYMENT RATE"
   V3730 = "HOUSEHOLD ID # 74"
   V3731 = "FU PRIMACY WITHIN HU";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V3403 GE 99 THEN V3403=.;
IF V3404 GE 999 THEN V3404=.;
IF V3405 GE 99999 THEN V3405=.;
IF V3406 GE 9 THEN V3406=.;
IF V3408 GE 9 THEN V3408=.;
IF V3409 GE 9 THEN V3409=.;
IF V3412 GE 9 THEN V3412=.;
IF V3414 GE 9 THEN V3414=.;
IF V3456 GE 9 THEN V3456=.;
IF V3457 GE 9 THEN V3457=.;
IF V3460 GE 9 THEN V3460=.;
IF V3461 GE 9 THEN V3461=.;
IF V3462 GE 9 THEN V3462=.;
IF V3467 GE 9 THEN V3467=.;
IF V3468 GE 9 THEN V3468=.;
IF V3469 GE 9 THEN V3469=.;
IF V3470 GE 9 THEN V3470=.;
IF V3471 GE 9 THEN V3471=.;
IF V3474 GE 99999 THEN V3474=.;
IF V3484 GE 9 THEN V3484=.;
IF V3485 GE 9 THEN V3485=.;
IF V3486 GE 9 THEN V3486=.;
IF V3504 GE 99 THEN V3504=.;
IF V3505 GE 9 THEN V3505=.;
IF V3506 GE 999 THEN V3506=.;
IF V3508 GE 99 THEN V3508=.;
IF V3509 GE 9 THEN V3509=.;
IF V3510 GE 99 THEN V3510=.;
IF V3514 GE 9 THEN V3514=.;
IF V3515 GE 9 THEN V3515=.;
IF V3516 GE 9 THEN V3516=.;
IF V3517 GE 9 THEN V3517=.;
IF V3518 GE 9 THEN V3518=.;
IF V3519 GE 9 THEN V3519=.;
IF V3520 GE 99999 THEN V3520=.;
IF V3521 GE 9 THEN V3521=.;
IF V3523 GE 9 THEN V3523=.;
IF V3524 GE 9 THEN V3524=.;
IF V3525 GE 9 THEN V3525=.;
IF V3526 GE 9 THEN V3526=.;
IF V3527 GE 9 THEN V3527=.;
IF V3529 GE 999 THEN V3529=.;
IF V3530 GE 9 THEN V3530=.;
IF V3531 GE 99 THEN V3531=.;
IF V3532 GE 9 THEN V3532=.;
IF V3533 GE 9 THEN V3533=.;
IF V3534 GE 9 THEN V3534=.;
IF V3535 GE 9 THEN V3535=.;
IF V3536 GE 9 THEN V3536=.;
IF V3537 GE 9 THEN V3537=.;
IF V3538 GE 9 THEN V3538=.;
IF V3539 GE 99 THEN V3539=.;
IF V3540 GE 9 THEN V3540=.;
IF V3541 GE 99 THEN V3541=.;
IF V3542 GE 9 THEN V3542=.;
IF V3543 GE 99 THEN V3543=.;
IF V3544 GE 99 THEN V3544=.;
IF V3545 GE 99 THEN V3545=.;
IF V3546 GE 9 THEN V3546=.;
IF V3547 GE 999 THEN V3547=.;
IF V3548 GE 9 THEN V3548=.;
IF V3549 GE 999 THEN V3549=.;
IF V3550 GE 9 THEN V3550=.;
IF V3551 GE 9 THEN V3551=.;
IF V3552 GE 9 THEN V3552=.;
IF V3553 GE 999 THEN V3553=.;
IF V3554 GE 99 THEN V3554=.;
IF V3555 GE 99 THEN V3555=.;
IF V3556 GE 9 THEN V3556=.;
IF V3557 GE 9 THEN V3557=.;
IF V3558 GE 9 THEN V3558=.;
IF V3559 GE 9 THEN V3559=.;
IF V3560 GE 99 THEN V3560=.;
IF V3561 GE 9 THEN V3561=.;
IF V3562 GE 9 THEN V3562=.;
IF V3563 GE 9 THEN V3563=.;
IF V3564 GE 999 THEN V3564=.;
IF V3565 GE 9 THEN V3565=.;
IF V3566 GE 9 THEN V3566=.;
IF V3567 GE 9 THEN V3567=.;
IF V3568 GE 999 THEN V3568=.;
IF V3569 GE 9 THEN V3569=.;
IF V3570 GE 99 THEN V3570=.;
IF V3571 GE 9 THEN V3571=.;
IF V3572 GE 99 THEN V3572=.;
IF V3573 GE 99 THEN V3573=.;
IF V3574 GE 99 THEN V3574=.;
IF V3575 GE 99 THEN V3575=.;
IF V3576 GE 99 THEN V3576=.;
IF V3577 GE 9 THEN V3577=.;
IF V3578 GE 9 THEN V3578=.;
IF V3579 GE 999 THEN V3579=.;
IF V3580 GE 9 THEN V3580=.;
IF V3581 GE 999 THEN V3581=.;
IF V3582 GE 9 THEN V3582=.;
IF V3583 GE 9 THEN V3583=.;
IF V3584 GE 9 THEN V3584=.;
IF V3585 GE 999 THEN V3585=.;
IF V3586 GE 9 THEN V3586=.;
IF V3587 GE 99 THEN V3587=.;
IF V3588 GE 99 THEN V3588=.;
IF V3589 GE 99 THEN V3589=.;
IF V3590 GE 9 THEN V3590=.;
IF V3591 GE 9 THEN V3591=.;
IF V3592 GE 999 THEN V3592=.;
IF V3593 GE 9 THEN V3593=.;
IF V3594 GE 9 THEN V3594=.;
IF V3595 GE 9 THEN V3595=.;
IF V3596 GE 9 THEN V3596=.;
IF V3597 GE 999 THEN V3597=.;
IF V3599 GE 9 THEN V3599=.;
IF V3600 GE 999 THEN V3600=.;
IF V3601 GE 9 THEN V3601=.;
IF V3602 GE 99 THEN V3602=.;
IF V3603 GE 99 THEN V3603=.;
IF V3604 GE 99 THEN V3604=.;
IF V3605 GE 9 THEN V3605=.;
IF V3606 GE 9 THEN V3606=.;
IF V3607 GE 9 THEN V3607=.;
IF V3608 GE 9 THEN V3608=.;
IF V3609 GE 9 THEN V3609=.;
IF V3610 GE 99 THEN V3610=.;
IF V3611 GE 99 THEN V3611=.;
IF V3614 GE 9 THEN V3614=.;
IF V3615 GE 9 THEN V3615=.;
IF V3616_1 GE 9 THEN V3616_1=.;
IF V3616_2 GE 9 THEN V3616_2=.;
IF V3617 GE 99 THEN V3617=.;
IF V3618 GE 999 THEN V3618=.;
IF V3619 GE 9 THEN V3619=.;
IF V3620 GE 99 THEN V3620=.;
IF V3621 GE 99 THEN V3621=.;
IF V3622 GE 9 THEN V3622=.;
IF V3623 GE 99 THEN V3623=.;
IF V3624 GE 9 THEN V3624=.;
IF V3625 GE 9 THEN V3625=.;
IF V3626 GE 9 THEN V3626=.;
IF V3627 GE 9 THEN V3627=.;
IF V3628 GE 9 THEN V3628=.;
IF V3629 GE 9 THEN V3629=.;
IF V3630 GE 9 THEN V3630=.;
IF V3631 GE 9 THEN V3631=.;
IF V3632 GE 9 THEN V3632=.;
IF V3633 GE 9 THEN V3633=.;
IF V3634 GE 9 THEN V3634=.;
IF V3635 GE 9 THEN V3635=.;
IF V3636 GE 9 THEN V3636=.;
IF V3638 GE 9 THEN V3638=.;
IF V3640 GE 99 THEN V3640=.;
IF V3641 GE 999 THEN V3641=.;
IF V3642 GE 99 THEN V3642=.;
IF V3643 GE 999 THEN V3643=.;
IF V3644 GE 9 THEN V3644=.;
IF V3645 GE 9 THEN V3645=.;
IF V3646 GE 9 THEN V3646=.;
IF V3647 GE 99 THEN V3647=.;
IF V3648 GE 99 THEN V3648=.;
IF V3649 GE 99 THEN V3649=.;
IF V3650 GE 99 THEN V3650=.;
IF V3651 GE 9 THEN V3651=.;
IF V3652 GE 9 THEN V3652=.;
IF V3654 GE 9 THEN V3654=.;
IF V3655 GE 99 THEN V3655=.;
IF V3656 GE 999 THEN V3656=.;
IF V3657 GE 9 THEN V3657=.;
IF V3658 GE 9 THEN V3658=.;
IF V3659 GE 9 THEN V3659=.;
IF V3660 GE 9 THEN V3660=.;
IF V3661 GE 9 THEN V3661=.;
IF V3662 GE 9 THEN V3662=.;
IF V3663 GE 9 THEN V3663=.;
IF V3664 GE 9 THEN V3664=.;
IF V3665 GE 9 THEN V3665=.;
IF V3666 GE 9 THEN V3666=.;
IF V3667 GE 9 THEN V3667=.;
IF V3668 GE 9 THEN V3668=.;
IF V3669 GE 9 THEN V3669=.;
IF V3670 GE 9 THEN V3670=.;
IF V3671 GE 9 THEN V3671=.;
IF V3672 GE 999 THEN V3672=.;
IF V3673 GE 9 THEN V3673=.;
IF V3701=9 THEN V3701=.;
IF V3702=9 THEN V3702=.;
IF V3703=9 THEN V3703=.;
IF V3707=99999 THEN V3707=.;
IF V3708=9 THEN V3708=.;
IF V3709=9 THEN V3709=.;
IF V3710=9 THEN V3710=.;
IF V3711=9 THEN V3711=.;
IF V3713=9.9 THEN V3713=.;
IF V3720=9 THEN V3720=.;
IF V3724=9 THEN V3724=.;
IF V3725=9 THEN V3725=.;
IF V3726=9 THEN V3726=.;
IF V3727=9 THEN V3727=.;
IF V3728=9 THEN V3728=.;
IF V3729=9 THEN V3729=.;
 
file rawdat lrecl=608;
put    
v3402
v3410
v3417
v3418
v3419
v3420
v3423
v3424
v3431
v3432
v3440
v3441
v3442
v3443
v3444
v3445
v3446
v3447
v3463
v3464
v3465
v3466
v3470
v3471
v3472
v3476
v3488
v3489
v3490
v3492
v3493
v3505
v3507
v3508
v3509
v3510
v3522
v3524
v3525
v3528
v3532
v3534
v3544
v3545
v3571
v3572
v3573
v3598
v3603
v3604
v3629
v3631
v3638
v3639
v3663
v3666
v3676
v3699
v3704
v3720
v3721
v30145
;

 proc means;
 run; 
